class GroundItem
  attr_reader :name
  
  def initialize(object)
    raise Exception "Parameter is expected to be of type Tiled::MapObject" unless object.is_a? Tiled::MapObject
    # puts object

    attributes = object.attributes
    properties = object.properties
    @name = properties.type

    x = attributes.x.to_i
    y = attributes.y.to_i
    width = attributes.width.to_i
    height = attributes.height.to_i
    @position = {x: x, y: y}
    @size = {w: width, h: height}
    # puts @name
  end

  def to_h
    {
      **@position,
      **@size,
      path: "sprites/#{@name}.png",
      primitive_marker: :sprite
    }
  end

  def collision_rect
    {
      **@position,
      **@size
    }
  end
end